//
//  BINotLinkedPunchOutWindow.h
//  BIViews
//
//  Created by Eric Hochmeister on 09/04/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class BITimeSlip;
@class MCSearchField;
@class MCArrayController;
@class BIProject;

enum
{
	BINOTLINKED_PUNCHOUT_LINK_BUTTON = 0,
	BINOTLINKED_CANCEL_BUTTON = 1
};

@interface BINotLinkedPunchOutWindow : NSWindowController {

	IBOutlet MCArrayController* _projectsController;
	IBOutlet NSTextField* _timeSlipCommentary;
	IBOutlet MCSearchField* _projectsSearchField;
	
	NSArray* _timeSlips;
	
	BOOL _punchOut;
}

- (NSArray *)timeSlips;
- (void)setTimeSlips:(NSArray *)aTimeSlips;

- (NSArrayController *)projectsController;

- (IBAction)endNotLinkedPunchOutWindow:(id)sender;
- (IBAction)linkToProject:(id)sender;

- (IBAction)listActiveProjects:(id)sender;
- (IBAction)listAllProjects:(id)sender;

- (BOOL)punchOut;
- (void)setPunchOut:(BOOL)flag;

- (BIProject*)project;


@end
